<?php
    session_start();
    
    require_once(__DIR__.'/include/PhpSpreadsheet/src/PhpSpreadsheet/Spreadsheet.php');
    $spreadsheet = require_once __DIR__.'/include/PhpSpreadsheet/src/PhpSpreadsheet/Spreadsheet.php';
    
    //use PhpOffice\PhpSpreadsheet\Spreadsheet;
    //use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
    
    
    $_SESSION["FotoPerfil"];
    $_SESSION["NombreUsuario"];
    $_SESSION['Permisos'];
    $_SESSION['Expediente'];
    $_SESSION['sesa'];
    $_SESSION['correo_supervisor'];
    $_SESSION['linea'];    

if(isset($_SESSION["Expediente"])){
    
    //
    
    #Conexion BD
    include("include/conexion.php");
    
    #Cerrar sesion
    if(isset($_POST['cerrar_session'])){
        session_destroy();
        header("location: Index.php");
    }
    
    #Funcion Consultas a BD
    function ConsultBD($mysqli, $Consulta, $Dat){
        
        if(!($sentencia = $mysqli->prepare($Consulta))){
            echo "\nFallo la preparacion: (". $mysqli ->errno.")". $mysqli ->error;
        }else{
            $sentencia->bind_param("s", $Dat);  
            if(!($sentencia->execute())){
                echo "Falló la ejecución: (" . $sentencia->errno . ") " . $sentencia->error;    
            }else{
        		$Result = $sentencia->get_result(); 
            }
            return $Result;
        }
    }
    
    #Codigo para generar el calendario
    $monthNames = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", 
    "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
    
    
    ///// OBTIENE EL MES ACTUAL ////
    if (!isset($_REQUEST["mes"])) $_REQUEST["mes"] = date("n");
    if (!isset($_REQUEST["anio"])) $_REQUEST["anio"] = date("Y");
    
    $cMonth = $_REQUEST["mes"];
    $cYear = $_REQUEST["anio"];
    
    //// TEMPORALES /////
    $prev_year = $cYear;
    $next_year = $cYear;
    
    /// CALCULA EL MES ANTERIO7 Y EL SIGUIENTE ////
    $prev_month = $cMonth-1;
    $next_month = $cMonth+1;
     
    if ($prev_month == 0 ) {
        $prev_month = 12;
        $prev_year = $cYear - 1;
    }
    if ($next_month == 13 ) {
        $next_month = 1;
        $next_year = $cYear + 1;
    }
    
    
    #Ocultar Tabla de mantenimiento
    $hideForm = "none";
    
    #Ocultar calendario para mostrar mantenimiento
    if(isset($_POST['Mantenimiento'])){
        
        $_POST['IdDate'];
        
        $hideSelec = "none";
        $hideForm = "block";
    }
    
    #Guardar Mantenimiento
    if(isset($_POST['SaveMant'])){
    
        $ID =  $_POST["SaveMant"];
        
        if(!($Update = $mysqli->prepare('INSERT INTO RegistroMantenimiento (Id, fecha, change_wheel, change_struc, descripcion) VALUES(?,?,?,?,?)'))){
            echo "Falló la preparación: (" . $mysqli->errno . ") " . $mysqli->error;        
        }else{
            $Update->bind_param("sssss", $_POST['IdMant'.$ID], $_POST['DateNow'.$ID], $_POST['ChangeRueda'.$ID], $_POST['ChangeTorqueo'.$ID], $_POST['descripcionMant'.$ID]);  
            if(!($Update->execute())){
                echo "Falló la ejecución: (" . $Update->errno . ") " . $Update->error;    
            }
        }
        
        
        $SelectDate = "SELECT * FROM CarrosTubular where Id = ?";
        $ConsultDates = ConsultBD($mysqli, $SelectDate, $ID);
        $rowDate = $ConsultDates->fetch_assoc();
        
        
        $NewDate = $rowDate['DataFuture'];
        
        ////Calcuar nueva fecha
        $myDateTime = DateTime::createFromFormat('Y-m-d', $rowDate['DataFuture']);
        
        $obj_Periodo = print_r($rowDate['Periodo'], true);
        $obj_Frecuencia = print_r($rowDate['Frecuencia'], true);
        
        date_add($myDateTime, date_interval_create_from_date_string($obj_Frecuencia.$obj_Periodo));
        
        $New_obj = print_r(date_format($myDateTime, 'Y-m-d'), true);
        
        
        if(!($Update = $mysqli->prepare('UPDATE CarrosTubular SET Data = ?, DataFuture = ? WHERE Id = ?'))){
            echo "Falló la preparación: (" . $mysqli->errno . ") " . $mysqli->error;        
        }else{
            $Update->bind_param("sss", $NewDate, $New_obj, $ID);  
            if(!($Update->execute())){
                echo "Falló la ejecución: (" . $Update->errno . ") " . $Update->error;    
            }else{
                echo "<script> alert('El registro del mantenimiento con Id: ".$_POST['IdMant'.$ID]." se realizó con exito.'); </script>";
                
                
                $para      = 'anyel9nav1@gmail.com';
                $titulo    = 'Mantenimiento realizado al carro tubular con ID: '.$_POST['IdMant'.$ID];
                $mensaje   = 'El Carro tubular con ID: '.$_POST['IdMant'.$ID]."\r\n"."Recibio mantenimiento el dia ".date("d-m-Y")."\r\n"."Proxima fecha a mantenimiento es: ".$rowDate['DataFuture'];
                
                mail($para, $titulo, $mensaje);

                
                echo "<script>location.href = 'PreventiveMaintenance.php';</script>";
            }
        }
        

    }
    
    if(isset($_POST['MonthReport'])){
        
        
        
        $spreadsheet = new Spreadsheet();
        $writer = new Xlsx($spreadsheet);
        
        
        
        $writer->save('./doc_exportados/reporte_de_excel.xlsx');

        
    }
        
?>
<!DOCTYPE html>
<html>
<head>
	<title>Carros Tubulares</title>
	
	<link rel="stylesheet" type="text/css" href="css/bootstrap-tableV1.18.3.css">
	<link rel="stylesheet" type="text/css" href="css/bootstrapV5.0.css">
    <script src="js/jqueryV3.1.0.js"></script>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <meta charset="utf-8">
	<style>
			
		.round_table, .round {
            border-collapse:separate;
            border-spacing: 10;
            border-radius:10px;
            -moz-border-radius:10px;
            -webkit-border-radius: 5px;    
        }
	    
	    #TablaMantenimiento{
	        text-align: center
	    }
	    
	    #Icon {
	        border: none;
	        background: none;
	    }

        .tableCalendar {
            text-align: center;
            padding: .2em .5em;
            border: 1px solid black;
        }

	</style>
</head>
<body>
    <!---Conexion a BD --->
    <?php include("include/menu.php"); ?>
    
    <br><br><br> 
    
    <!---Tabla de calendario --->
    <div class="mx-auto table-responsive" style="display: <?php  echo $hideSelec; ?>">
        <table align="center" width="10%">
            <tr align="center">
                <td>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
                        <thead class="table-dark">
                            <tr align="center">
                                <td width="20%" align="center"><a href="<?php echo $_SERVER["PHP_SELF"]."?mes=". $prev_month."&anio=".$prev_year; ?>" style="color:#FFFFFF"><span class="material-icons">arrow_back_ios</span></a></td>
                                <td width="60%" style="color:#FFFFFF"><strong><?php echo $monthNames[$cMonth-1].' '.$cYear; ?></strong></td>
                                <td width="20%" align="center"><a href="<?php echo $_SERVER["PHP_SELF"]."?mes=". $next_month."&anio=".$next_year; ?>" style="color:#FFFFFF"><span class="material-icons">arrow_forward_ios</span></a></td>
                            </tr>
                        </thead>    
                    </table>
                </td>
            </tr>
            <tr>
                <td align="center">
                    <table width="100%" cellpadding="6" cellspacing="6" style="border:3px solid black" class="round_table tableCalendar">
                        <thead>
                            <th class="round" align="center"><strong>Domingo</strong></th>
                            <th class="round" align="center"><strong>Lunes</strong></th>
                            <th class="round" align="center"><strong>Martes</strong></th>
                            <th class="round" align="center"><strong>Miercoles</strong></th>
                            <th class="round" align="center"><strong>Jueves</strong></th>
                            <th class="round" align="center"><strong>Viernes</strong></th>
                            <th class="round" align="center"><strong>Sabado</strong></th>
                        </thead>
                        <tbody>
                            <tr>
                        <?php 
                            $timestamp = mktime(0,0,0,$cMonth,1,$cYear);
                            $maxday = date("t",$timestamp);
                            $thismonth = getdate ($timestamp);
                            $startday = $thismonth['wday'];
                            for ($i=0; $i<($maxday+$startday); $i++) {
                                if(($i % 7) == 0 ) echo "<tr>";
                                if($i < $startday) echo "<td></td>";
                                else  {
                                
                                    $FechaActual = $cYear."/".$cMonth."/".($i - $startday + 1);
                                    #Consulta BD para fechas de mantenimiento
                                    
                                    $SelectCalendario = "SELECT * FROM CarrosTubular where Data = ?";
                                    $FechaTubular = ConsultBD($mysqli, $SelectCalendario, $FechaActual);
                                    
                            	    $Ret = mysqli_fetch_array($FechaTubular);
                            	    
                            	    
                                    if($_SESSION['Permisos'] != "Soporte"){ 
                                        
                                ?>
                            		    <td align="center"> 
                            		    
                                            <div style="float: left; width:64%; text-align:right;">                            		    
                                		        <?php echo ($i - $startday + 1);  ?>
                                		    </div>
                                		    <div style="float: right;width:30%;">
                                		        <?php if(!empty($Ret) and $Ret['Linea'] == $_SESSION['linea']){ ?> <button type="button" value="<?php echo $FechaActual;?>" class="btn" data-bs-toggle="modal" data-bs-target="#ViewMant"><span class="material-icons">settings</span></button> <?php }?> 
                            		        </div>
                            		    
                            		    </td>
                            	<?php 
                                    }else{
                                ?>        
                                        <td align="center" > 
                                            <div style="float: left; width:64%; text-align:right;">
                                                <?php echo ($i - $startday + 1); ?> 
                                            </div>
                                            <div style="float: right; width:35%">
                                                <?php if(!empty($Ret)){ ?><button type="button" id="Icon" class="material-icons ViewMant" value="<?php echo $FechaActual;?>" class="btn" data-bs-toggle="modal" data-bs-target="#ViewMant">settings</button> <?php }?>
                                            </div>
                                        </td>         
                                <?php    
                                    }    
                                }
                                if(($i % 7) == 6 ) echo "</tr>";
                            }
                        ?>
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr><td><hr></td></tr>    
            <tr align="center">
                <form role="form" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
                    <td colspan="7"><input type="submit" class="btn btn-dark" name="MonthReport" id="MonthReport" value="Reporte Mensual"/></td>
                </form>
            </tr>
        </table>
        <br><br>
    </div>
    
    
    <!--------      Tabla de manteniminetos preventivos   --------->
    <div class="mx-auto table-responsive" style="display: <?php echo $hideForm; ?>;  width: 92%;">
        <form role="form" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data">
            <table data-toggle="table" data-pagination="true" data-search="true" id="TablaMantenimiento">
                <thead class="table-dark">
                    <tr>
                        <th colspan="5" class="bg-success">Información General</th>
                        <th colspan="4" class="bg-info">Mantenimiento</th>
                    </tr>
        			<tr>
                        <th>Id</th>
                        <th>Foto</th>
                        <th>Fecha</th>
                        <th>Tipo de carro</th>
                        <th>Ruedas</th>
        				<th>Cambio de Ruedas</th> 
        				<th>Estructura, Retorqueo y cambio de componentes</th>
        				<th>Descripción</th>
        				<th>Acciones</th>
        			</tr>
        		</thead>
        		<tbody>
        	        <?php 
        	        
        	        $SelectAll = "SELECT * FROM CarrosTubular where Data = ?";
                    $IdDate = $_POST['IdDate'];
                    
                    $IdCart = ConsultBD($mysqli, $SelectAll, $IdDate);
        	        
        	        while($row = $IdCart->fetch_assoc()){ ?>  
                    <tr>
                        <td><input type="text" id='IdMant' name="IdMant<?php echo $row["Id"] ?>" style="border: 0;" value="<?php echo $row["Id"] ?>"  hidden><span><?php echo $row["Id"] ?></span></td>
                        <td><img class="rounded img-fluid" src="<?php echo $row['Foto']; ?>"><span id="Foto<?php echo $row['Id']; ?>" hidden><?php echo $row['Foto']; ?></span></td>
                        <td><input type="text" id="DateNow" name="DateNow<?php echo $row["Id"] ?>" style="border: 0;" value="<?php echo date('Y-m-d'); ?>"  hidden><span><?php echo date('Y-m-d'); ?></span></td>
                        <td><span id='TipoCarro'><?php echo $row["Tipo_carro"]; ?></span></td>
                        <td><span id='Ruedas'><?php echo $row["Ruedas"]; ?></span></td>
                        <td>
                            <select class="form-control" name="ChangeRueda<?php echo $row["Id"] ?>" id="ChangeRueda">
    							<option value="">Seleccione una opción</option>
    							<option value="Si">SI</option>
    							<option value="No">NO</option>
    						</select>
    					</td>
    					<td>
                            <select class="form-control" name="ChangeTorqueo<?php echo $row["Id"] ?>" id="ChangeTorqueo">
    							<option value="">Seleccione una opción</option>
    							<option value="Si">SI</option>
    							<option value="No">NO</option>
    						</select>
    					</td>
    					<td><textarea class="form-control" id="descripcionMant" name="descripcionMant<?php echo $row["Id"] ?>" rows="3" cols="30"></textarea></td>
    					<td><button type="submit" name="SaveMant" id="SaveMant" value="<?php echo $row["Id"] ?>" class="btn btn-success"><span class="material-icons">save</span></button></td>
                    </tr>    
                    <?php }?>
                </tbody>
            </table>
        </form>        
    </div>

    <!--Cambios de mantenimiento--->
	<div class="modal fade" id="ViewMant" role="dialog">
        <div class="modal-dialog modal-dialog-scrollable">
            <div class="modal-content">
            <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel">¿Desea realizar un mantenimiento preventivo en esta fecha?</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                    
                <!-- Modal Body -->
                <div class="modal-body">
                    <p class="statusMsg"></p>
                    <form role="form" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data" >
                        <div class="form-group">
                            <label for="inputFirstName">Fecha Actual</label>
                            <input type="text" class="form-control" id="IdDate" name="IdDate" readonly/>
                        </div>
                            <!-- Modal Footer -->
	                    <div class="modal-footer">
	                        <button type="button" class="btn btn-default" data-bs-dismiss="modal" id="clear">Cancelar</button>
	                        <button type="submit" name="Mantenimiento" id="Mantenimiento" class="btn btn-success">Mantenimiento</button>
	                    </div>
                	</form>
                </div>
            </div>
        </div>
    </div>
    
    
    <!----SCRIPT EDITAR ----->   
	<script type="text/javascript">
		$(document).ready(function(){
			$(document).on('click','.ViewMant', function(){
			    
				var id=$(this).val();
                $('#IdDate').val(id);
                
			});
		});	
	</script>
    
</body>

<script src="js/jqueryV3.5.1.js"></script>
<script src="js/bootstrapV5.0.js"></script>
<script src="js/bootstrap-tableV1.18.3.js"></script>

</html>
<?php
}else{




}

?>