<?php
	session_start();
	error_reporting (E_ALL ^ E_NOTICE);

	$_SESSION["FotoPerfil"];
	$_SESSION["NombreUsuario"];
	$_SESSION['Permisos'];
	$_SESSION['Expediente'];
	$_SESSION['sesa'];
	$_SESSION['correo_supervisor'];
	$_SESSION['linea'];
	
	if(isset($_SESSION["Expediente"])){
        
        #Conexion
		include("include/conexion.php");
		
        function ConsultSelec($mysqli, $NewSentencia, $Var){
            
            if (!($Select = $mysqli->prepare($NewSentencia))) {
                echo "Falló la preparación: (" . $mysqli->errno . ") " . $mysqli->error;    
            }else{
                if(!empty($Var)){
                    $Select->bind_param('s', $Var);    
                }
                if(!($Select->execute())){
                    echo "Falló la ejecución: (" . $Select->errno . ") " . $Select->error;    
                }else{
                    $resultado = $Select->get_result(); 
                }
            }
            return $resultado;
        }
       
        #Cerrar sesion    
		if(isset($_POST['cerrar_session'])){
			session_destroy();
			header("location: Index.php");
		}

		?>
		<!DOCTYPE html>
		<html>
		<head>
			<title>Welcome LeanRoom</title>
			<link rel="stylesheet" type="text/css" href="css/bootstrapV5.0.css">
			<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
			<style type="text/css">
				
				body{

					background-repeat: no-repeat;
					background-attachment: fixed;
					background-position: top center;
					background-size: cover;
				}
				
				#myChart, #barChart{
				    background: white;
				}
			</style>
		</head>
		<body background="img/index.png">
			<?php
			include("include/menu.php");
			?>	
			<div class="container-fluid">
	            <h1 class="page-header text-center" style =" color:white; ">Reporte de Gastos de Lean</h1>
                <div class="container">
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    Gasto total: <strong><span id="connected_users">0</span></strong>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    Facturación del día: <strong>$ <span id="daily_revenue">0.00</span></strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
            
            <br><br>
            <!--- STOCK TOTAL EN ALMACEN --->
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="bart-body">
                            <div class="card">
                                <div class="card-body">
                                    <div class="Mychart">
                                        <canvas id="barChart" style="height:10px; width:20px"></canvas>
                                    </div>
                                </div>
                            </div>    
                        </div>
                    </div>
                </div>
            </div>
            
            <br><br>
            
            <div class="container">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="bart-body">
                            <div class="card">
                                <div class="card-body">
                                    <!--- GASTO POR PERSONAL OPERATIVO --->
                                    <div class="pie-body">
                                        <div class="Mychart">
                                            <canvas id="pieChart" style="height:10px"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>    
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="bart-body">
                            <div class="card">
                                <div class="card-body">
                                    <!--- GASTO POR MES --->
                                    <div class="Mychart">
                                        <canvas id="barChartMes" style="position: relative; height:60vh; width:100vw"></canvas>
                                    </div>
                                </div>
                            </div>    
                        </div>
                    </div>  
                </div>
            </div>
            
            <br><br>
		</body>
		<!----- Configuracion de graficas ----->
		
		<!-- Grafica de Barra -->
        <script>
            const bar = document.getElementById('barChart').getContext('2d');
            const barChart = new Chart(bar, {
                type: 'bar',    
                data:{
                    
                    <?php
                    $Var = "";
                    $NewSentencia = 'SELECT * FROM herramienta_leanroom';
                    $LabelX = ConsultSelec($mysqli, $NewSentencia, $Var);
                    ?>
                    
                    labels  :   [   <?php while($row = mysqli_fetch_array($LabelX)){ ?>
                                    "<?php echo $row['catalogo']; ?>",
                                    <?php } ?> 
                                ],
                    datasets: [
                                {
                                    <?php
                                       $ValConsul = ConsultSelec($mysqli, $NewSentencia, $Var);
                                    ?>
                    
                                    label : 'Catalogos',
                                    data:   [ <?php while($row = mysqli_fetch_array($ValConsul)){ ?>
                                             "<?php echo $row['pz']; ?>",
                                              <?php } ?> 
                                            ],
                                    backgroundColor: ['rgba(255, 206, 86, 0.2)'],
                                    borderColor: ['rgba(255, 206, 86, 1)'],
                                    borderWidth: 1
                                }
                              ]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        },
                        plugins: {
                            title: {
                                display: true,
                                text: 'STOCK EN ALMACEN'
                            }
                        }
                    }
                    
            });
            
            const pie = document.getElementById('pieChart').getContext('2d');
            const pieChart = new Chart(pie, {
                type: 'pie',    
                data:{
                    
                    <?php
                    $Var = "";
                    $NewSentencia = 'SELECT * FROM usuarios';
                    $ListUsuarios =& ConsultSelec($mysqli, $NewSentencia, $Var);
                    ?>
                    
                    labels  :   [   <?php while($row = mysqli_fetch_array($ListUsuarios)){ ?>
                                    "<?php echo $row['firstName']; ?>",
                                    <?php } ?> 
                                ],
                    datasets: [
                                {
                                    <?php   $ListUsuarios =& ConsultSelec($mysqli, $NewSentencia, $Var); ?>
                                    label : 'Gasto por personal operativo',
                                    data:   [ <?php while($row = mysqli_fetch_array($ListUsuarios)){ 
                                                $NewSentencia = 'SELECT SUM(CostoTotal) FROM registro WHERE sesa = ?';
                                                $TotalUser = mysqli_fetch_array(ConsultSelec($mysqli, $NewSentencia, $row['sesa']));
                                                ?>
                                             "<?php echo round($TotalUser['SUM(CostoTotal)'], 2, PHP_ROUND_HALF_UP); ?>",
                                              <?php } ?> 
                                            ],
                                    backgroundColor: [
                                        <?php
                                            for($i=0; $i<=6;$i++)  
                                            {  
                                                
                                                do{
                                                    $a = random_int(0,999);
                                                    $b = random_int(0,999);
                                                    $c = random_int(0,999);
                                                    
                                                    $color = $a.",".$b.",".$c.",12";
                                                        
                                                }while($color === "255,255,255,12" or $color === "253,254,254,12" or $color === "251,252,252,12" or $color === "247,249,249,12" or $color === "244,246,247,12" or $color === "240,243,244,12" or $color === "236,240,241,12");
                                                
                                                
                                                ?>
                                                    "rgba(<?php echo $a; ?>, <?php echo $b; ?>, <?php echo $c; ?>, 12)",
                                                <?php    
                                            }
                                        ?>
                                    ],
                                    
                                    borderColor: [
                                        'rgba(0, 0, 0, 1)',
                                        'rgba(0, 0, 0, 1)',
                                        'rgba(0, 0, 0, 1)',
                                        'rgba(0, 0, 0, 1)',
                                        'rgba(0, 0, 0, 1)',
                                        'rgba(0, 0, 0, 1)',
                                        'rgba(0, 0, 0, 1)'
                                    ],
                                    
                                    borderWidth: 1
                                }
                              ]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        },
                        plugins: {
                            title: {
                                display: true,
                                text: 'GASTO POR PERSONAL OPERATIVO'
                            }
                        }
                    }
            });
            
            const barMes = document.getElementById('barChartMes').getContext('2d');
            const barChartMes = new Chart(barMes, {
                type: 'bar',    
                data:{
                    labels  : ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
                    datasets: [
                                {
                                    label : 'Gasto por mes',
                                    data:   [   <?php $array = array('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12');
                                                    $NewSentencia= 'SELECT SUM(CostoTotal) FROM registro WHERE MONTH(fecha) = ?';
                                                    for($i = 0; $i<=11; $i++){
                                                        $GastoMes = mysqli_fetch_array(ConsultSelec($mysqli, $NewSentencia, $array[$i]));
                                                ?>        
                                                "<?php echo round($GastoMes['SUM(CostoTotal)'], 2, PHP_ROUND_HALF_UP); ?>",
                                                    
                                                <?php } ?> 
                                            ],    
                                    backgroundColor: [
                                        'rgba(255, 99, 132, 0.2)',
                                        'rgba(54, 162, 235, 0.2)',
                                        'rgba(255, 206, 86, 0.2)',
                                        'rgba(75, 192, 192, 0.2)',
                                        'rgba(153, 102, 255, 0.2)',
                                        'rgba(255, 159, 64, 0.2)'
                                    ],
                                    borderColor: [
                                        'rgba(255, 99, 132, 1)',
                                        'rgba(54, 162, 235, 1)',
                                        'rgba(255, 206, 86, 1)',
                                        'rgba(75, 192, 192, 1)',
                                        'rgba(153, 102, 255, 1)',
                                        'rgba(255, 159, 64, 1)'
                                    ],
                                    borderWidth: 1
                                }
                              ]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        },
                        plugins: {
                            title: {
                                display: true,
                                text: 'GASTO POR MES'
                            }
                        }
                    }  
            });
        </script>
        
        <!-- Librerias -->
		<script src="js/bootstrapV5.0.js"></script>
		</html>

<?php
	}else{

		echo "<script> alert('No haz iniciado sesion correctamente...'); </script>";
        echo "<script>location.href = 'Index.php';</script>";
	}
	

?>	