


<!DOCTYPE html>
<html>
<head>
	<title>Generar gráficas de barras con PHP usando Chart.js</title>
	    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css"
          integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" />
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>

	<!-- ChartJS -->
	<script src="https://cdn.jsdelivr.net/npm/chart.js" integrity="sha512-sW/w8s4RWTdFFSduOTGtk4isV1+190E/GghVffMA9XczdJ2MDzSzLEubKAs5h0wzgSJOQTRYyaz73L3d6RtJSg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <style>

    </style>
</head>
<body>
<div class="container-fluid">
	<h1 class="page-header text-center">Reporte de datos usando Chart.js</h1>
	<div class="row">
		<div class="col-md-3">
		    <div class="container">
                <div class="row">
                    <div class="col-sm">
                        <div class="card">
                            <div class="card-body">
                                Usuarios conectados en este momento: <strong><span id="connected_users">0</span></strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm">
                        <div class="card">
                            <div class="card-body">
                                Facturación del día: <strong>$ <span id="daily_revenue">0.00</span></strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>    
            
			<h3 class="page-header text-center">Añadir compra/venta</h3>
			<form method="POST" action="add_data.php">
				<div class="form-group">
					<label>Monto:</label>
					<input type="text" class="form-control" name="amount" required>
				</div>
				<div class="form-group">
					<label>Fecha:</label>
					<input type="date" class="form-control" name="sales_date" required>
				</div>
				
				<div class="form-group">
					<label>Tipo de transacción:</label>
					<select name="type" id="type" class='form-control' required>
						<option value="">--Selecciona--</option>
						<option value="1">Ventas</option>
						<option value="2">Compras</option>
					</select>
				</div>
				<button type="submit" class="btn btn-primary"><span class="glyphicon glyphicon-floppy-disk"></span> Guardar</button>
			</form>
		</div>
		
		<div class="col-md-12">
			<div class="box box-success">
                <div class="box-header with-border">
                	<?php
                		//set timezone
    					date_default_timezone_set('America/El_Salvador');
    					$year = date('Y');
                	?>
                  <h3 class="box-title" aling ="center">Reporte de compras & Ventas <?php echo $year; ?></h3>
                </div>
            </div>
        </div>    
		
		<div class="container">
            <div class="row">
                <div class="col-sm-6">
                    <div class="chart">
                        <canvas id="myChart" style="position: relative; height:80vh; width:120vw"></canvas>
                    </div>
                </div>   
                <div class="col-sm-6">
                    <div class="bart-body">
                        <div class="Mychart">
                            <canvas id="barChart" style="position: relative; height:80vh; width:120vw"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>  
        
        <div class="container">
            <div class="row">
                <div class="col-sm-4">
                    <div class="Mychart">
                        <canvas id="doughnutChart"style="height:10px"></canvas>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="pie-body">
                        <div class="Mychart">
                            <canvas id="pieChart" style="height:10px"></canvas>
                        </div>
                    </div>
                </div>    
                <div class="col-sm-4">
                    <div class="radar-body">
                        <div class="Mychart">
                            <canvas id="radarChart" style="height:100px"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>  
        
        <div class="container">
            <div class="row">
                <div class="col-sm">
                    <div class="mix-body">
                        <div class="Mychart">
                            <canvas id="mixChart" style="height:100px"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="polar-body">
                        <div class="Mychart">
                            <canvas id="polarChart" style="height:100px"></canvas>
                        </div>
                    </div>
                </div>    
             </div>
        </div>     
		
		<?php
        #Conexion
		include("conexion.php");
        $User = "07";
        $Sentencia = 'SELECT SUM(CostoTotal) FROM registro WHERE MONTH(fecha) = ?';
        if (!($Select = $mysqli->prepare($Sentencia))) {
                echo "Falló la preparación: (" . $mysqli->errno . ") " . $mysqli->error;    
            }else{
                $Select->bind_param("s",$User);
                if(!($Select->execute())){
                    echo "Falló la ejecución: (" . $Select->errno . ") " . $Select->error;    
                }else{
                    $resultado = $Select->get_result();
                    
                    $row = mysqli_fetch_array($resultado);

                }
            }

        echo round(  $row['SUM(CostoTotal)'] , 2, PHP_ROUND_HALF_UP);



?>

 <!-- Grafica de Barra -->
<script>
    const bar = document.getElementById('barChart').getContext('2d');
    const barChart = new Chart(bar, {
        type: 'bar',    
        data:{
            labels  : ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
            datasets: [
                        {
                            label : 'Compras',
                            data:   [ "<?php echo "10"; ?>",
                                     "<?php echo "100"; ?>",
                                     "<?php echo "50"; ?>",
                                     "<?php echo "80"; ?>",
                                     "<?php echo "90"; ?>",
                                     "<?php echo "110"; ?>",
                                     "<?php echo "150"; ?>",
                                     "<?php echo "130"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "2"; ?>",
                                     "<?php echo "20"; ?>"],
                            backgroundColor: ['rgba(255, 206, 86, 0.2)'],
                            borderColor: ['rgba(255, 206, 86, 1)'],
                            borderWidth: 1
                            
                        },
                        {
                            label : 'Ventas',
                            data:   [ "<?php echo "40"; ?>",
                                     "<?php echo "20"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "4"; ?>",
                                     "<?php echo "89"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "156"; ?>",
                                     "<?php echo "160"; ?>",
                                     "<?php echo "160"; ?>",
                                     "<?php echo "104"; ?>",
                                     "<?php echo "24"; ?>",
                                     "<?php echo "204"; ?>"],
                            backgroundColor: ['rgba(153, 102, 255, 0.2)'],  
                            borderColor: ['rgba(153, 102, 255, 1)'],
                            borderWidth: 1
                        }      
                      ]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
    });
</script>
<!-- Grafica de Linea -->
<script>
const line = document.getElementById('myChart').getContext('2d');
const myChart = new Chart(line, {
    type: 'line',
    data: {
        labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
        datasets: [{
            label: '# of Votes',
            data: [12, 19, 3, 5, 2, 3],
            backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(255, 206, 86, 0.2)',
                'rgba(75, 192, 192, 0.2)',
                'rgba(153, 102, 255, 0.2)',
                'rgba(255, 159, 64, 0.2)'
            ],
            borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(255, 206, 86, 1)',
                'rgba(75, 192, 192, 1)',
                'rgba(153, 102, 255, 1)',
                'rgba(255, 159, 64, 1)'
            ],
            borderWidth: 1
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
<!-- Grafica de dona -->
<script>
const doughnut = document.getElementById('doughnutChart').getContext('2d');
const doughnutChart = new Chart(doughnut, {
    type: 'doughnut',
    data: {
        labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
        datasets: [{
            label: '# of Votes',
            data: [12, 19, 3, 5, 2, 3],
            backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(255, 206, 86, 0.2)',
                'rgba(75, 192, 192, 0.2)',
                'rgba(153, 102, 255, 0.2)',
                'rgba(255, 159, 64, 0.2)'
            ],
            borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(255, 206, 86, 1)',
                'rgba(75, 192, 192, 1)',
                'rgba(153, 102, 255, 1)',
                'rgba(255, 159, 64, 1)'
            ],
            borderWidth: 1
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
<!-- Grafica de pie -->
<script>
const pie = document.getElementById('pieChart').getContext('2d');
const pieChart = new Chart(pie, {
    type: 'pie',
    data: {
        labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
        datasets: [{
            label: '# of Votes',
            data: [12, 19, 3, 5, 2, 3],
            backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(255, 206, 86, 0.2)',
                'rgba(75, 192, 192, 0.2)',
                'rgba(153, 102, 255, 0.2)',
                'rgba(255, 159, 64, 0.2)'
            ],
            borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(255, 206, 86, 1)',
                'rgba(75, 192, 192, 1)',
                'rgba(153, 102, 255, 1)',
                'rgba(255, 159, 64, 1)'
            ],
            borderWidth: 1
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
<!-- Grafica mixta -->
<script>
const mix = document.getElementById('mixChart').getContext('2d');
const mixChart = new Chart(mix, {
    type: 'scatter',
    data: {
          labels: [
                    'January',
                    'February',
                    'March',
                    'April'
                  ],
                  datasets: [{
                    type: 'bar',
                    label: 'Bar Dataset',
                    data: [10, 20, 30, 40],
                    borderColor: 'rgb(255, 99, 132)',
                    backgroundColor: 'rgba(255, 99, 132, 0.2)'
                  }, {
                    type: 'line',
                    label: 'Line Dataset',
                    data: [20, 10, 5, 6],
                    fill: false,
                    borderColor: 'rgb(54, 162, 235)'
          }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
<!-- Grafica de polarArea -->
<script>
const polar = document.getElementById('polarChart').getContext('2d');
const polarChart = new Chart(polar, {
    type: 'polarArea',
    data: {
        labels: ['Red', 'Blue', 'Yellow', 'Green', 'Purple', 'Orange'],
        datasets: [{
            label: '# of Votes',
            data: [12, 19, 3, 5, 2, 3],
            backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(255, 206, 86, 0.2)',
                'rgba(75, 192, 192, 0.2)',
                'rgba(153, 102, 255, 0.2)',
                'rgba(255, 159, 64, 0.2)'
            ],
            borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(255, 206, 86, 1)',
                'rgba(75, 192, 192, 1)',
                'rgba(153, 102, 255, 1)',
                'rgba(255, 159, 64, 1)'
            ],
            borderWidth: 1
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
 <!-- Grafica de Radar -->
<script>
    const radar = document.getElementById('radarChart').getContext('2d');
    const radarChart = new Chart(radar, {
        type: 'radar',    
        data:{
            labels  : ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
            datasets: [
                        {
                            label : 'Compras',
                            data:   [ "<?php echo "10"; ?>",
                                     "<?php echo "100"; ?>",
                                     "<?php echo "50"; ?>",
                                     "<?php echo "80"; ?>",
                                     "<?php echo "90"; ?>",
                                     "<?php echo "110"; ?>",
                                     "<?php echo "150"; ?>",
                                     "<?php echo "130"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "2"; ?>",
                                     "<?php echo "20"; ?>"],
                            backgroundColor: ['rgba(255, 206, 86, 0.2)'],
                            borderColor: ['rgba(255, 206, 86, 1)'],
                            borderWidth: 1
                            
                        },
                        {
                            label : 'Ventas',
                            data:   [ "<?php echo "40"; ?>",
                                     "<?php echo "20"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "4"; ?>",
                                     "<?php echo "89"; ?>",
                                     "<?php echo "10"; ?>",
                                     "<?php echo "156"; ?>",
                                     "<?php echo "160"; ?>",
                                     "<?php echo "160"; ?>",
                                     "<?php echo "104"; ?>",
                                     "<?php echo "24"; ?>",
                                     "<?php echo "204"; ?>"],
                            backgroundColor: ['rgba(153, 102, 255, 0.2)'],  
                            borderColor: ['rgba(153, 102, 255, 1)'],
                            borderWidth: 1
                        }      
                      ]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
    });
</script>

</body>
</html>